Option Explicit

Sub Gauge (Object As Control, CX As Integer, CY As Integer, Value As Single, NeedleClr As Long, BackClr As Long, ForeClr As Long)

Dim PI, PVal                    'Declare variables 
    PI = 3.1415928              'Set PI (The calculation 4 * Arctan 1 takes too long)
    Object.ScaleMode = 3        'Set scale to pixels
    
        'Visual Basic draws circles counterclockwise, as you would expect.
        'Since we want values to increment as we go clockwise, we will invert
        'the value sent.  If you want to increment counterclockwise, delete
        'the next line from the module.
        Value = 1 - Value       'Invert value

        'Paint pie slice representing face of gauge display
        Object.FillStyle = 0
        Object.FillColor = BackClr
        Object.Circle (CX, CY), 100, ForeClr, -(PI / 4) + .1, -(3 * PI / 4) - .1
        
        'Paint needle onto gauge face
        PVal = ((PI * Value) / 2) + (PI / 4)    'Convert to a rotation amount in radians
        Object.FillColor = NeedleClr
        Object.Circle (CX, CY), 75, ForeClr, -(PVal - .02), -(PVal + .02)

        'Paint the object background over the bottom of the gauge
        Object.FillColor = Object.BackColor
        Object.ForeColor = Object.BackColor
        Object.Circle (CX, CY), 50, , -(PI / 4) + .14, -(3 * PI / 4) - .14
        
        'Paint the bottom border of the gauge
        Object.ForeColor = ForeClr
        Object.Circle (CX, CY), 50, , (PI / 4) - .1, (3 * PI / 4) + .1

End Sub

